#!/bin/bash

dev=$1
mtu=$2
link_mtu=$3
stage=$4

# get address
#
addr=`/sbin/ifconfig tun | grep 'inet6 addr:' | sed -e 's/.*addr: //' -e 's/ .*//'`

[ X$addr == X ] && {
	logger "openvpn, dev $dev: unable to get ipv6 address from dev 'tun'"
	exit 1
}

set -e

ifconfig $dev up
ifconfig $dev add $addr
logger "openvpn, dev $dev: bound to ipv6 addr $addr"
