#!/usr/bin/perl -w
#
# ---------------------------------------------------------------------------------------------
# /etc/awstats/robots.local.pm
# ---------------------------------------------------------------------------------------------
#
# ::copy::
# ::maintainer::
#
# ---------------------------------------------------------------------------------------------

# RobotsSearchIDOrder
# It contains all matching criteria to search for in log fields. This list is
# used to know in which order to search Robot IDs.
# Most frequent ones are in list1, used when LevelForRobotsDetection is 1 or more
# Minor robots are in list2, used when LevelForRobotsDetection is 2 or more
# Note: Robots IDs are in lower case, '_', ' ' and '+' are changed into '[_+ ]' and are quoted.
#-------------------------------------------------------

# added to:
#
#  - robot IDs list @RobotsSearchIDOrder_list1 (first field, id)
#  - robot description list, %RobotsHashIDLib, both fields, id and desc
#
# NB: this is a strided list, elements are couples: id,desc
#
# 'sample\-bot\.com', '<a href="http://www.sample-robot.com/" target="_blank">SAMPLE BOT HOMEPAGE</a>',
#
# ADD/INSERT YOUR LOCAL DEFINITIONS HERE
#
@localRobots = (
 'webliste\.ch', '<a href="http://www.webliste.ch/" target="_blank">Tiger.ch (Webliste.ch)</a>',
);



# ---------------------------------------------------------------------------------------------
# IMPORTANT!! DO NOT CHANGE LINES BELOW!!
# ---------------------------------------------------------------------------------------------
#
# add localRobots to lists
#
my ($__key,$__des,$__idx);

for ($__idx=0;$__idx<scalar(@localRobots);$__idx+=2) {
	$__key = $localRobots[$__idx];
	$__des = (defined $localRobots[$__idx+1] ? $localRobots[$__idx+1] : "" );
	push( @RobotsSearchIDOrder_list1, $__key );
	$RobotsHashIDLib{$__key} = $__des;
}
undef $__key;
undef $__des;
undef $__idx;

1;
