#!/bin/bash

set -e -u

execute=true
dummycmd=

[ "X${1:-}" = "X-n" ] && {
	shift
	execute=false
	dummycmd="echo (dummy)"
}

udel()
{
	grep -q "^$1:" /etc/passwd || return 0

	fls=$(find / -user $1 2>/dev/null) || :
	[ "X$fls" != "X" ] && {
		echo
		echo " cannot remove user '$1', there are still"
		echo " files owned by this user on the system:"
		echo "$fls"
		echo
		return 1
	}
	echo " remove user $1"
	$dummycmd userdel $1 || return $?
	return 0
}

gdel()
{
	grep -q "^$1:" /etc/group || return 0

	fls=$(find / -group $1 2>/dev/null) || :
	[ "X$fls" != "X" ] && {
		echo
		echo " cannot remove group '$1', there are still"
		echo " files owned by this group on the system:"
		echo "$fls"
		echo
		return 1
	}
	echo " remove group $1"
	$dummycmd groupdel $1 || return $?
	return 0
}

udel temp	|| :
udel operator	|| :

# 2016.11.17

udel Debian-exim	|| :
gdel Debian-exim	|| :

for user in $(grep "^systemd-" /etc/passwd | sed -e 's/:.*//')
do
	udel $user	|| :
done

exit 0
