# Default init script logging functions suitable for Ubuntu.
# See /lib/lsb/init-functions for usage help.

#[ku]
# patches to have init.d scripts logging to /var/log also!
#
# ::copy::
# ::maintainer::
#
ku_log_write_buffer()
{
	_KUSA_LOG_PHASE=${_KUSA_LOG_PHASE:-"RC"}
	DEBUG=${DEBUG:-"false"}

    	[ "${loop:-n}" != y ] || return 0	# don't dupe messages

	# 1. try to use syslog
	#
	[ -f /var/run/syslogd.pid -a -x /usr/bin/logger ] && {
		# should flush RAM and disk buffers first?
		[ X"${_ku_log_buffer:-}" != "X" ] && ku_log_flush_buffer
		[ -s /lib/init/rw/_ku_log_buffer ] && ku_log_flush_disk_buffer
		/usr/bin/logger -t $_KUSA_LOG_PHASE "${_ku_log_line_buffer:-}$@"
		_ku_log_line_buffer=
		return 0
	}

	# 2. syslogd not running, try to write to a disk buffer using
	#    the /lib/init/rw tmpfs filesystem
	#
	(echo -n "" >>/lib/init/rw/_ku_log_buffer) 2>/dev/null && {
		# should flush ram buffer first?
		[ X"${_ku_log_buffer:-}" != "X" ] && ku_log_flush_buffer
		echo "(`date +%H:%M:%S`) ${_ku_log_line_buffer:-}$@" >>/lib/init/rw/_ku_log_buffer
		_ku_log_line_buffer=
		return 0
	}

	# 3. can't write to disk, use a ram temp buffer
	#    (this doesn't work, I think, because init scripts are not
	#    included but runs on separate shell process)
	#
	_ku_log_buffer="${_ku_log_buffer:-}$@\n"
}

ku_log_flush_disk_buffer()
{
	local msg="[ku] saving log buffer to /var/log/boot.log"
	_KUSA_LOG_PHASE=${_KUSA_LOG_PHASE:-"RC"}
	/usr/bin/logger -t $_KUSA_LOG_PHASE "$msg"
	echo -n " * $msg ... "
	echo -e "\nLOG SAVED ON `date`"	>>/var/log/boot.log
	cat /lib/init/rw/_ku_log_buffer	>>/var/log/boot.log
	rm -f /lib/init/rw/_ku_log_buffer
	echo "ok"
	return 0
}

ku_log_flush_buffer()
{
	local line=
	$DEBUG && echo "[ku-debug] flushing RAM buffer"	>>/lib/init/rw/_ku_log_buffer
	echo -e "${_ku_log_buffer:-}"			>>/lib/init/rw/_ku_log_buffer
	$DEBUG && echo "[ku-debug] RAM buffer flushed"	>>/lib/init/rw/_ku_log_buffer
	_ku_log_buffer=
	return 0
}
#[ku] end

log_use_usplash () {
    if [ "${loop:-n}" = y ]; then
        return 1
    fi
    type usplash_write >/dev/null 2>&1
}

log_to_console () {
    [ "${loop:-n}" != y ] || return 0
    [ "${QUIET:-no}" != yes ] || return 0

    # Only output to the console when we're given /dev/null
    stdin=`readlink /proc/self/fd/0`
    [ "${stdin#/dev/null}" != "$stdin" ] || return 0

    func=$1
    shift

    loop=y $func "$@" "(CONSOLE)" </dev/console >/dev/console 2>&1 || true
}

log_success_msg () {
    if log_use_usplash; then
        usplash_write "TEXT   $*" || true
    fi

    log_to_console log_success_msg "$@"

    echo " * $@"
    ku_log_write_buffer " * $@"		# [ku] patch 2010/08
}

log_failure_msg () {
    if log_use_usplash; then
        usplash_write "TEXT   $*" || true
    fi

    log_to_console log_failure_msg "$@"
    ku_log_write_buffer " * $@"		# [ku] patch 2010/08

    if log_use_fancy_output; then
        RED=`$TPUT setaf 1`
        NORMAL=`$TPUT op`
        echo " $RED*$NORMAL $@"
    else
        echo " * $@"
    fi
}

log_warning_msg () {
    if log_use_usplash; then
        usplash_write "TEXT   $*" || true
    fi

    log_to_console log_warning_msg "$@"
    ku_log_write_buffer " * $@"		# [ku] patch 2010/08

    if log_use_fancy_output; then
        YELLOW=`$TPUT setaf 3`
        NORMAL=`$TPUT op`
        echo " $YELLOW*$NORMAL $@"
    else
        echo " * $@"
    fi
}

log_begin_msg () {
    log_daemon_msg "$1"
}

log_daemon_msg () {
    if [ -z "$1" ]; then
        return 1
    fi

    if log_use_usplash; then
        usplash_write "TEXT $*" || true
    fi

    log_to_console log_daemon_msg "$@"
    [ "${loop:-n}" != y ] && _ku_log_line_buffer="${_ku_log_line_buffer:-}$@"	#[ku] patch 2010/08

    if log_use_fancy_output && $TPUT xenl >/dev/null 2>&1; then
        COLS=`$TPUT cols`
        if [ "$COLS" ] && [ "$COLS" -gt 6 ]; then
            COL=`$EXPR $COLS - 7`
        else
	    COLS=80
            COL=73
        fi
        # We leave the cursor `hanging' about-to-wrap (see terminfo(5)
        # xenl, which is approximately right). That way if the script
        # prints anything then we will be on the next line and not
        # overwrite part of the message.

        # Previous versions of this code attempted to colour-code the
        # asterisk but this can't be done reliably because in practice
        # init scripts sometimes print messages even when they succeed
        # and we won't be able to reliably know where the colourful
        # asterisk ought to go.

        printf " * $*       "
        # Enough trailing spaces for ` [fail]' to fit in; if the message
        # is too long it wraps here rather than later, which is what we
        # want.
        $TPUT hpa `$EXPR $COLS - 1`
        printf ' '
    else
        echo " * $@"
        COL=
    fi
}

log_progress_msg () {
    :
}

log_end_msg () {
    if [ -z "$1" ]; then
        return 1
    fi

    if log_use_usplash; then
        if [ "$1" -eq 0 ]; then
            usplash_write "SUCCESS OK" || true
        else
            usplash_write "FAILURE failed" || true
        fi
    fi

    log_to_console log_end_msg "$@"

    # [ku] patch 2010/08 start
    if [ "$1" -eq 0 ]
    then
    	ku_log_write_buffer " OK"
    else
    	ku_log_write_buffer " FAIL!"
    fi
    # [ku] patch 2010/08 end

    if [ "$COL" ] && [ -x "$TPUT" ]; then
        printf "\r"
        $TPUT hpa $COL
        if [ "$1" -eq 0 ]; then
            echo "[ OK ]"
        else
            printf '['
            $TPUT setaf 1 # red
            printf fail
            $TPUT op # normal
            echo ']'
        fi
    else
        if [ "$1" -eq 0 ]; then
            echo "   ...done."
        else
            echo "   ...fail!"
        fi
    fi
    return $1
}

log_action_msg () {
    if log_use_usplash; then
        usplash_write "TEXT $*" || true
    fi

    log_to_console log_action_msg "$@"

    echo " * $@"
    ku_log_write_buffer " * $@"		# [ku] patch 2010/08
}

log_action_begin_msg () {
    log_daemon_msg "$@..."
}

log_action_cont_msg () {
    log_daemon_msg "$@..."
}

log_action_end_msg () {
    # In the future this may do something with $2 as well.
    log_end_msg "$1" || true
}
