# /etc/dns/hosts.src
#
# ::copy::
# ::maintainer::
#
#------------------------------------------------------------------------------
#
# questo file serve a generare in modo automatico sia le definizioni del DNS
# sia, eventualmente, il file /etc/hosts
#
# lanciare  -----> sh make-dns-files.sh <----- dopo le modifiche per ricreare
# tutte le definizioni del caso
#
# la sintassi e' simile al file /etc/hosts, con queste differenze e
# caratteristiche:
#
# - tutto quello che segue il '#' viene considerato un commento e quindi
#   scartato
#
# - la parola chiave NET serve a definire una parte comune a tutte le
#   definizioni degli ip che seguno, ad esempio NET 10.20
#
# - le righe di definizione degli hosts devono contenere come primo campo
#   l'ip (o una parte se e' stata usata la definizione NET), seguito da uno
#   o piu' nomi; il primo nome diventa quello ufficiale dell'host, gli altri
#   sono aliases
#
# - se un indirizzo e' indicato in modo completo x.x.x.x questo viene preso
#   come e' indipendetemente dal fatto che sia stato dichiarato NET
#
# altre keywords sono descritte direttamente nell'esempio che segue
#
#------------------------------------------------------------------------------

# common parms

CREATE_HOSTS	no	# don't write in /etc/hosts

MAIN_FORWARD	1.2.3.4	# if defined, forward requests to this host


# SAMPLE ENTRIES, CHANGE THEM TO SUIT YOUR NEEDS!

DOMAIN	sampledomain

#	------------------------------------------------------------
#	main network
#
NET	10.1.1

201	server	gw proxy timesync install updates ldapserver mysqlhost mail ftp repo

# ws
1	workstation1
2	workstation2

# dhcp
141	dyna-1
142	dyna-2
143	dyna-3

#	sample of other network but same domain
NET	10.1.2
1	other1

#	sample of other combinations of net/addresses
#	(warning, using the NET statement you setup a reverse
#	zone lookup for this network in your djbdns)
#
NET	10.1
3.1	host10-1-3-1
4.1	host10-1-4-1

#	a fully address, this will not setup any reverse zone lookup
1.2.3.4	host1-2-3-4



