#!/bin/bash
#
# crea tarfile con comandi e configs necessari, per poterli installare
# su macchine non kusa -- attenzione, copia i configs di questa
# macchina, quindi vanno poi modificati a mano
#
files="
	usr/sbin/kubackup
	usr/sbin/kubackup-net
	usr/bin/mirror
	etc/xinetd.d/kubackup-net
	tmp/kubackup-*.conf
"
configs="
	etc/kubackup-*.conf
"
tarfile="/tmp/kubackup-tarball.tar.bz2"


cd /

trap "rm -f /tmp/kubackup-*.conf; exit 255" 1 2 3

echo "  copying configs to /tmp ..."
rm -f /tmp/kubackup-*.conf
cp `ls $configs` /tmp

echo "  creating tarfile $tarfile ..."
tar cvfj $tarfile `ls $files`
status=$?

if [ $status == 0 ]
then
	echo -e "\nmanual installation tarfile ready:\n"
else
	echo -e "\nerrors during preparation of tarfile:\n"
fi
ls -l $tarfile

rm -f /tmp/kubackup-*.conf
exit $status
