#!/bin/bash
#
# ::maintainer::
# /etc/init.d/network-check
#
# controlla che la rete sia attiva (intesa come rete utenti, quindi lo fa
# eseguendo il ping ad un server opportunamente indicato)
#
# inoltre sincronizza, in caso di successo, il time della workstation con
# quello del server principale (/etc/cron.hourly/timesync.sh)
#
# lo stop e` dummy
#

# includes network-ws defines
. /etc/default/kusa-services || exit 1

[ x"$KUSA_SERVICE_CHECK" = x ] && {
	echo "error: KUSA_SERVICE_CHECK host not defined in /etc/defaults/kusa-services"
	exit 1
}

desc="[ku] Checking Network Connectivity"

. /lib/lsb/init-functions

GiveMessage()
{
	message=${1:-"failed"}

	# toglie splash screen grafico e ripristina console
	DO_NOT_SWITCH_VT=yes /etc/init.d/usplash start

	message="$message

	ATTENZIONE: rete non attiva, controlla il cavo.

	"
	echo -e "$message" >/var/log/last_boot_error
	log_failure_msg "$message"
	sleep 20
}



do_start()
{
	log_action_begin_msg "$desc"

	# wait a bit, just to be sure that udev & co brings
	# up the interfaces
	#
	sleep 2

	# ping the designed host and check is network is up
	#
	if ! ping -c 1 -w 20 $KUSA_SERVICE_CHECK 2>/dev/null >/dev/null
	then
		GiveMessage "(network down)"
		[ -x /etc/init.d/disable-nss-ldap.sh ] && \
			/etc/init.d/disable-nss-ldap.sh
	else
		log_action_end_msg 0 "ok"
		update_time
	fi
}


do_stop()
{
	return 0
}

usage()
{
	echo "usage: $0 { start | stop | restart }" >&2
	exit 1
}


update_time()
{
	[ -f /etc/cron.hourly/timesync.sh ] && {
		log_action_begin_msg "[ku] Sync time from timeserver: "
		sh /etc/cron.hourly/timesync.sh
		log_action_end_msg 0 "ok"
	}
}



case "$1" in
    start)	do_start ;;
    stop)	do_stop ;;
    restart)	do_stop ; do_start ;;
    *)		usage ;;
esac

exit 0
