#!/bin/bash
#
# /etc/openvpn/ckkeys.ch
#
# ::copy::
# ::maintainer::
#
CMD=$(basename $0)
CMDVER="1.2"
CMDSTR="$CMD v$CMDVER (2017/11)"

stat=0

SP='[[:space:]]'

echo -e "\nchecking conf files\n"
for conf in *.conf
do
	keys=$(egrep "^secret$SP|^ca$SP|^cert$SP|^key$SP" $conf \
		| sed -e "s/#.*//" -e "s/.*$SP//")
	for key in $keys
	do
		printf " %-20s %-30s " $conf $key
		if [ -f $key ]
		then
			echo "ok"
		else
			echo "KEYFILE NOT FOUND"
			stat=1
		fi
	done
done

echo -e "\nchecking keyfiles files\n"
for key in $(ls *.key *.crt 2>/dev/null)
do
	printf " %-30s " $key
	conf=$(egrep -l "^secret$SP$key|^key$SP$key|^ca$SP$key|^cert$SP$key" *.conf)
	[ "$conf" == "" ] && {
		echo "KEYFILE NOT USED"
		stat=1
		continue
	}
	nconf=$(echo "$conf" | wc -l)
	case $nconf in
	  1)	echo "$conf" ;;
	  *)	echo "(MULTI)" $conf ;;
	esac
done

exit $stat
