#!/bin/bash
#
# ::copy::
# ::maintainer::
#
# users-home.sh
#
# - controlla esistenza in rete del server $KUSA_SERVICE_HOMES
# - se esiste e ping ok, monta le directories remote
# - se non esiste avverte l'utente (toglie usplash)
#

. /etc/default/kusa-services || exit 1

[ -z "$KUSA_SERVICE_HOMES" ] && exit 0


desc="User Homes Server"

. /lib/lsb/init-functions

STOP_ME()
{
	message=${1:-"failed"}

	# toglie splash screen grafico e ripristina console
	DO_NOT_SWITCH_VT=yes /etc/init.d/usplash start

	message="$message

	ATTENZIONE: il server utenti '$KUSA_SERVICE_HOMES' non e\` raggiungibile,
	oppure la cartella /home non e\` correttamente collegata
	al server (fstab). Controlla eventualmente la connessione del
	cavo di rete.

	"
	echo -e "$message" >/var/log/last_boot_error
	log_failure_msg "$message"
	sleep 20
}



do_start()
{
	log_action_begin_msg "Checking $desc connectivity"

	ping -c 1 -w 10 $KUSA_SERVICE_HOMES 2>/dev/null >/dev/null || {
		STOP_ME "server '$KUSA_SERVICE_HOMES' non raggiungibile"
		exit 1
	}

	home="`grep "/home[ ,	]" /etc/fstab`"
	[ "$home" = "" ] && {
		STOP_ME "/home non definita in /etc/fstab"
		exit 1
	}

	cat /etc/fstab | while read dev mountpoint type options trush
	do
		case "$dev" in
		    $KUSA_SERVICE_HOMES:*)
			if mountpoint -q $mountpoint
			then
				# fix eventuale discrepanza tra
				# /etc/mtab e /proc/mounts
				#
				mount -f $mountpoint 2>/dev/null
			else
				log_warning_msg "mounting $desc: $mountpoint"
				mount $mountpoint
			fi
			;;
		esac
	done

	set $home; home=$2
	mountpoint -q $home || STOP_ME "home non montata"

	log_action_end_msg 0 "ok"
}


do_stop()
{
	cat /proc/mounts | while read dev mountpoint trush
	do
		case "$dev" in
		    $KUSA_SERVICE_HOMES:*)
			echo " * unmounting $desc: $dev"
			umount $mountpoint
			;;
		esac
	done
}

usage()
{
	echo "usage: $0 { start | stop | restart }" >&2
	exit 1
}



case "$1" in
    start)	do_start ;;
    stop)	do_stop ;;
    restart)	do_stop ; do_start ;;
    *)		usage ;;
esac

exit 0
