#!/bin/bash
#
# __copy1__
# __copy2__
#
# library, internal funcs and vars shared among jtools scripts
#
# included by script as
#  . jtfunctions.sh
#
trap 'echo -e "\n*INTR*\n"; exit 255' 1 2 3
trap 'echo -e "$0: unexpected error $? at $LINENO\n"' ERR


# early define, is used in vars definitions
#
_jt_cat()
{
	[ -s "$1" -a -f "$1" ] && cat "$1"
	return 0
}

# environment, system wide, as defined in /etc/default/jtools
#
#  - JTPATH: search path for projects
#  - JTCREATEPATH: new project default directory
#  - JTUSER: new project default user
#  - JTGROUP: new project default group
#  - JTSCMURL: repository server url (SCM: git, bazaar, fossil)
#
export JTPATH=
export JTCREATEPATH=
export JTUSER=
export JTGROUP=
export JTVERBOSE=
export JTSCMURL=

# get system wide definitions
#
[ -f /etc/default/jtools ] || { echo -e "\nerror: file /etc/default/jtools not found\n" >&2; exit 1; }
. /etc/default/jtools


# environment, for current project
#
#  - PRJ: full project directory path
#  - PRJNAME: project name (basename of $PRJ)
#  - PRJDESC: one line description
#
[ "X${HOME:-}" != "X" ] && {
	export PRJ=${PRJ:-$HOME}
	export PRJNAME=${PRJNAME:-$(basename $PRJ)}
	export PRJDESC=${PRJDESC:-$(_jt_cat $PRJ/etc/desc)}
}


# local vars (not exported)
#
#  - DEBUG: true/false, default: false
#  - VERBOSE: true/false, default: true
#  - CMD: command name
#
DEBUG=false
VERBOSE=true
CMD=$(basename "$0")


_jt_echo()
{
	$VERBOSE && echo -e "$@"
	return 0
}

_jt_error()
{
	status=$1 ; shift
	echo -e "[err] $*" >&2
	return $status
}

_jt_set_vars()
{
	local var
	local buf=
	local tmp="$(mktemp /tmp/${CMD}-var-XXXXXX)"

	rm -f $tmp
	for var
	do
		section=$(echo $var | sed -e 's/\..*//')
		var=$(echo $var | sed -e 's/.*\.//')
		varname="${section}_$var"
		echo "$varname=\"::$section.$var::\"" >>$tmp
	done
	buf=$(jtconf-parse --simple $tmp) || {
		status=$?
###echo "-- $tmp dump -------------------------------------------------------------" >&2
###cat $tmp >&2
###echo "-- $tmp dump (end) -------------------------------------------------------" >&2
		rm -f $tmp
		return $status
	}
	rm -f $tmp
	eval "$buf"
}

_jt_normalize_wiki_name()
{
	#echo "$1" | sed -e 's/-//g'
	echo "$1" | sed -e 's/^\(.\)/\u\1/' #-e 's/-//g'
}

_jt_valid_wiki_name()
{
	echo "$1" | grep -q "^[a-zA-Z][a-zA-Z0-9_-]*$"
}


_jt_search_template()
{
	local file=$1
	local dir

	for dir in	$PRJ/etc/templates $PRJ/lib/templates \
			__CONF__/templates \
			__LIB__/templates
	do
		[ -f "$dir/$file" ] && {
			echo "$dir/$file"
			return 0
		}
	done
	return 1
}

_jt_start_input_redirect()
{
	exec 9<&0 <"$1"
}
_jt_end_input_redirect()
{
	exec 0<&9 9<&-
}
