#!/bin/bash

set -e -u

# (MAIN)

orig_dir=$(pwd)

[ $# != 2 ] && {
	echo "usage: $0 packagename version" >&2
	exit 1
}

[ -d "$orig_dir/debian" ] || {
	echo "error: 'debian' dir not found" >&2
	echo "  you should run this command from the main package dir" >&2
	exit 1
}

pkgname="$1"
release="$2"
#arch=$(uname -m)

echo "
  PACKAGE: $pkgname v.$release
"

DEST="$orig_dir/debian/$pkgname"

# get config
#
cfg=$0; cfg=${cfg/.sh/}.conf
. $cfg


[ -f "$appimage_name" ] || {
	if [ -f $PRJ/work/$appimage_name ]
	then
		cp -a $PRJ/work/$appimage_name .
	else
		wget -O "$appimage_name" "$appimage_url/$appimage_name" || {
			rm -f "$appimage_name"
			echo "*ABORT*" >&2
			exit 1
		}
	fi
}
[ -f "$PRJ/work/$appimage_name" ] || {
	cp -a "$appimage_name" $PRJ/work/
	echo "  SAVED '$appimage_name' to $PRJ/work"
}
echo
ls -l $appimage_name
sleep 2 ####
echo

[ "X$appimage_keyserver_parms" != "X" ] && gpg $appimage_keyserver_parms

for key in $appimage_signatures
do
	keyname=$(basename "$key")
	rm -f "$keyname"
	echo -en "\nveryfing signature ... (wget) ... "
	wget -q -O "$keyname" "$key"
	echo -e "ok\n"
	gpg --verify "$keyname" "$appimage_name"
	rm -f "$keyname"
done
echo
echo "SIGNATURE OK"
echo

echo
echo "  DEST=$DEST"
echo "  installing executable in (DEST)/usr/bin ..."
[ -d "$DEST/usr/bin" ] || mkdir -p "$DEST/usr/bin"
rm -f $DEST/usr/bin/$appimage_name
cp -a $appimage_name "$DEST/usr/bin/"
chmod 755 "$DEST/usr/bin/$appimage_name"

cd "$DEST/usr/bin"
rm -f $bin_name
ln -s $appimage_name $bin_name

echo
ls -l $bin_name $appimage_name | sed -e 's/^/  /'
echo
sleep 1

cd "$orig_dir"
[ -f "$PRJ/work/$appimage_name" ] && {
	rm -f "$appimage_name"
}

exit 0
