#!/bin/bash
#
# libfiles.sh - bash functions to manage libfiles
#
# __copy1__
# __copy2__
#

## ku_get_template file
##
## search for a file in $TOOLKIT templates directories:
##
##  * /etc/$TOOLKDIR/templates		(custom)
##  * /usr/share/$TOOLKIT/templates	(default)
##
## if not defined, TOOLKIT default is '__TOOLKIT__"
##
ku_get_template()
{
	local file=$1
	local dir=
	local searchpath=

	TOOLKIT=${TOOLKIT:-__TOOLKIT__}
	searchpath="/etc/$TOOLKIT/templates /usr/share/$TOOLKIT/templates"

	for dir in $searchpath
	do
		[ -f "$dir/$file" -a -r "$dir/$file" ] && {
			echo "$dir/$file"
			return 0
		}
	done
	echo "error: template file '$file' not found" >&2
	echo "	(searchpath is: $searchpath)" >&2
	return 1
}
