#!/bin/sh
#
# truncates cwd if too long, for PROMPT_COMMAND and PS1
# updates also XTerm title, if enabled
#
# __copy1__
# __copy2__
#
# version 1.4 (2024-11-23)

# minimum chars left after the prompt
#
export KU_TRUNCATE_FREE_CHARS="20"

ku_truncate_cwd()
{
        local ps1=${PS1/:\/*/}			# remove path from PS1, if any
	      ps1=${ps1/:\$_ku_truncate*/}	# remove our truncated path, if any
	local cwd=`pwd`

	cwd=`awk --assign cwd="$cwd" --assign ps1="$ps1" '
	   BEGIN {
		cwdlen	= length( cwd );
		ps1len	= length( ps1 );
		columns = '${COLUMNS:-80}';
		needed	= '${KU_TRUNCATE_FREE_CHARS:-20}' + 3;

		maxlen 	= columns - ps1len - needed;

		if (cwdlen > maxlen) {
			len	= (maxlen - 3) / 3;
			ncwd	= substr( cwd, 0, len ) "...";
			ncwd	= ncwd substr( cwd, cwdlen - (len * 2) );
			cwd	= ncwd;
		}
		print cwd;
	   }' </dev/null`

	cwd=${cwd//\'/\'\\\'\'}	 # quote it
	echo "_ku_truncated_cwd='$cwd'"

	# must set/change terminal title?
	#
	if [ "X${KU_SET_PS1_SET_TERM_TITLE:-true}" = "Xtrue" ]
	then
		__title=
		__icontitle=
		if [ "X${PRJNAME:-}" != "X" ]
		then
			__title="`id -un`@`uname -n` :: $PRJNAME"
			__icontitle="$PRJNAME"
		else
			__title="`id -un`@`uname -n`"
			__icontitle="$__title"
		fi
		echo -ne "\033]0;$__title\007" >&2
		echo -ne "\033]1;$__icontitle\007" >&2
		unset __title
		unset __icontitle
	fi
	return 0
}

# lib/ku_truncate_cwd.sh (eof)
