#!/usr/bin/env /bin/bash
#
# /etc/profile.d/aliases.sh
# v1.6 (2026-01-27)
#
# __copy1__
# __copy2__
#
# ONLY FOR BASH, AND ONLY IF $PS1 ALREADY DEFINED (INTERACTIVE SHELLS)

case ${SHELL:-} in
  */bash)
    [ "X${PS1:-}" != "X" ] && {

	# usefull 'ls' aliases
	#
	alias ls='ls --color=auto'
	alias ll='ls -l'
	alias la='ls -la'
	alias l='ls -CF'


	# keep remove, move and copy safe
	#
	alias rm="rm -i"
	alias mv="mv -i"
	alias cp="cp -i"


	# just because we are lazy ...
	#
	alias h=history
	alias apt-search="apt-cache search"

	# this is not only we are lazy, but because when you want to reinstall a package there are
	# high chanches that the proxy local copy is out of date
	#
	alias apt-reinstall="apt-get -o Acquire::http::proxy=false update && apt-get clean && apt-get -o Acquire::http::proxy=false install --reinstall"

    }
    ;;
esac

# /etc/profile.d/aliases.sh (eof)
