# System-wide .bashrc file for interactive bash(1) shells.
#
# maintainer: KUBiC Labs (CH) - Lorenzo Canovi <lorenzo@kubiclabs.com>
# for copyright see /usr/share/doc/ku-base/copyright
#
# modified to include /etc/profile.d and /etc/profile-post.d


# To enable the settings / commands in this file for login shells as well,
# this file has to be sourced in /etc/profile.

# If not running interactively, don't do anything
[ -z "$PS1" ] && return

#[ku]
# includes /etc/profile.d only if not already done (uses "ll" alias to check)
#
alias | fgrep -q ' ll=' || {
	[ -d /etc/profile.d ] && {
  		for i in /etc/profile.d/*.sh
		do
    			[ -r $i ] &&. $i
  		done
  		unset i
	}
}
#[/ku]

# check the window size after each command and, if necessary,
# update the values of LINES and COLUMNS.
shopt -s checkwinsize

#[ku]
# properly expand env variables on directory expansion
# (ubuntu > 11.04 problem?)
#
shopt | grep -q direxpand && {
	shopt -s direxpand
}
#[/ku]


# set variable identifying the chroot you work in (used in the prompt below)
if [ -z "${debian_chroot:-}" ] && [ -r /etc/debian_chroot ]; then
    debian_chroot=$(cat /etc/debian_chroot)
fi

# set a fancy prompt (non-color, overwrite the one in /etc/profile)
PS1='${debian_chroot:+($debian_chroot)}\u@\h:\w\$ '

# Commented out, don't overwrite xterm -T "title" -n "icontitle" by default.
# If this is an xterm set the title to user@host:dir
#case "$TERM" in
#xterm*|rxvt*)
#    PROMPT_COMMAND='echo -ne "\033]0;${USER}@${HOSTNAME}: ${PWD}\007"'
#    ;;
#*)
#    ;;
#esac

# enable bash completion in interactive shells
#if ! shopt -oq posix; then
#  if [ -f /usr/share/bash-completion/bash_completion ]; then
#    . /usr/share/bash-completion/bash_completion
#  elif [ -f /etc/bash_completion ]; then
#    . /etc/bash_completion
#  fi
#fi

# if the command-not-found package is installed, use it
if [ -x /usr/lib/command-not-found -o -x /usr/share/command-not-found/command-not-found ]; then
	function command_not_found_handle {
	        # check because c-n-f could've been removed in the meantime
                if [ -x /usr/lib/command-not-found ]; then
		   /usr/lib/command-not-found -- "$1"
                   return $?
                elif [ -x /usr/share/command-not-found/command-not-found ]; then
		   /usr/share/command-not-found/command-not-found -- "$1"
                   return $?
		else
		   printf "%s: command not found\n" "$1" >&2
		   return 127
		fi
	}
fi

#[ku]
# includes /etc/profile-post.d (ALWAYS)
#
[ -d /etc/profile-post.d ] && {
	for i in /etc/profile-post.d/*.sh
	do
    		[ -r $i ] && . $i
  	done
  	unset i
}
#[/ku]
