#!/bin/sh
#
# sets PS1 shell prompt
#
# __copy1__
# __copy2__
#
# v1.3 (2024-11-23)


# ONLY IF $PS1 ALREADY DEFINED (INTERACTIVE SHELLS)

export KU_SET_PS1_SET_TERM_TITLE

[ -z "${PS1:-}" ] || {

	if [ -f /etc/debian_version ]
	then
		PS1="${debian_chroot:+($debian_chroot)}"
	else
		PS1=
	fi



	# NOT standard, current dir
	#
	# if present, uses ku_truncate_cwd pseudofunc (from ku-base package)
	# to set the current directory; warning! this change $PROMPT_COMMAND
	#
	if [ -f /lib/ku-base/ku_truncate_cwd.sh ]
	then
		# NOT standard, add user and hostname
		# don't use smart expansion, we need PS1 to be fully expanded
		# to process it later by ku_truncate_cwd
		#
		__uname=`uname -n`; __uname=${__uname/.*/}	# removes domain
		PS1="$PS1`id -un`@$__uname"
		unset __uname

		. /lib/ku-base/ku_truncate_cwd.sh
		export PROMPT_COMMAND="eval \`ku_truncate_cwd\`"
		PS1="$PS1:\$_ku_truncated_cwd"
	else
		# standard, add user and hostname
		PS1="$PS1\u@\h"
		PS1="$PS1:\w"
	fi


	# NOT standard, ku-jtools integration
	#
	if [ ! -z "${PRJNAME:-}" ]
	then
		PS1="[$PRJNAME] $PS1"
	fi

	# standard, trail
	#
	if [ `id -u` = 0 ]
	then
		PS1="$PS1# "
	else
		PS1="$PS1$ "
	fi

	export PS1

	return 0
}

# /etc/profile.d/set_ps1.sh (eof)
